using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///This control inherits from ComboBox. It automatically selects an item based on ALL text entered so far instead of just the 1st character
		///</summary>

		#endregion

	public class ComboBoxLookup : System.Windows.Forms.ComboBox
	{
		private System.Windows.Forms.Timer timer1;
		private System.ComponentModel.IContainer components;
		private bool _autoLookup = true;
		private bool _allowManualEntry = false;

		//

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// ComboBoxLookup class constructor. Creates the instance of the control.
		/// </summary>
		public ComboBoxLookup()
		{
			InitializeComponent();
		}
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/30/2002</CreationDate>
		///
		/// <summary>
		/// ComboBoxLookup class constructor. Adds control to container
		/// </summary>
		/// <param name="container">IContainer</param>
		public ComboBoxLookup(System.ComponentModel.IContainer container)
		{
			container.Add(this);
			InitializeComponent();
		}

		/// <summary> Description: Clean up any resources being used.</summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.timer1 = new System.Windows.Forms.Timer(this.components);
			// 
			// timer1
			// 
			this.timer1.Interval = 500;
			this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
			// 
			// ComboBoxLookup
			// 
			this.Size = new System.Drawing.Size(121, 21);
			this.KeyUp += new System.Windows.Forms.KeyEventHandler(this.ComboBoxLookup_KeyUp);
			this.Leave += new EventHandler(ComboBoxLookup_Leave);

		}
		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary> 
		/// Gets or stes lookup time delay, in milliseconds. Default is 100mS. Editable at design time
		/// </summary>
		[Category("Design"),
		Description("Sets the time, in milliseconds, between lookups"),
		DefaultValue("100"),
		Bindable(false),
		Browsable(true),
		]
		public int Interval
		{
			get
			{ 
				return this.timer1.Interval; 
			}
			set 
			{
				this.timer1.Interval = value; 
			}
		}

		/// <summary>
		/// Indicates whether automatic lookup feature should be enabled
		/// </summary>
		[Category("Design"),
		Description("Indicates whether automatic lookup feature should be enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool LookupEnabled
		{
			get
			{ 
				return this._autoLookup; 
			}
			set 
			{
				this._autoLookup = value; 
			}
		}

		/// <summary>
		/// Allows the user to manually enter input regardless of whether it exists in lookup.
		/// </summary>
		[Category("Design"),
		Description("Allows the user to manually enter input regardless of whether it exists in lookup."),
		DefaultValue(false),
		Bindable(false),
		Browsable(true),
		]
		public bool AllowManualEntry
		{
			get
			{ 
				return this._allowManualEntry; 
			}
			set 
			{
				this._allowManualEntry = value; 
			}
		}

		#endregion

		#region Methods

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///	
		/// <summary>
		/// Private method to find an entry in the combo box beginning with the text entered into the combo box
		/// </summary>
		private void LookupString()
		{
			if (this.Text.Length > 0)
			{
				int len = this.Text.Length;
				//
				//FindString() does not find the exact match first!
				//Checking for an exact match before calling FindString()
				for(int j=0;j<this.Items.Count;j++)
				{
					string entry = this.Items[j].ToString();
					if (entry == this.Text)
					{
						this.SelectedIndex = j;
						this.OnSelectedIndexChanged(EventArgs.Empty);
						//
						this.Select(len,this.Text.Length);
						return;
					}
				}
				//
				if (_autoLookup)
				{
					int i = this.FindString(this.Text,-1);
					if (i > -1)
					{
						this.SelectedIndex=i;
						this.OnSelectedIndexChanged(EventArgs.Empty);
						this.Select(len,this.Text.Length);
						return;
					}
				}
			}
			this.SelectedIndex = -1;
			this.OnSelectedIndexChanged(EventArgs.Empty);
		}

		#endregion

		#region Events

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///	
		/// <summary>
		/// Timer tick event handler. Calls LookupString method
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void timer1_Tick(object sender, System.EventArgs e)
		{
			this.timer1.Enabled = false;
			LookupString();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///	
		/// <summary>
		/// Key up event handler. Resets timer
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Key event args</param>
		private void ComboBoxLookup_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if ((e.KeyValue>32)||(this.Text.Length==0))
			{
				this.timer1.Enabled = false;
				this.timer1.Enabled = true;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2005</CreationDate>
		///	
		/// <summary>
		/// Leave event handler. Clears the combo box if no valid selection was made.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ComboBoxLookup_Leave(object sender, EventArgs e)
		{
			if (this.AllowManualEntry) return;

			if (this.LookupEnabled)
			{
				if (this.SelectedIndex < 0)
				{
					this.Text = "";
				}
			}
		}

		#endregion


	}
}

